/*
 * This file is subject to the terms and conditions defined in
 * file 'LICENSE.txt', which is part of this source code package.
 */

"use strict";(self.webpackChunk=self.webpackChunk||[]).push([["88"],{34339:function(e){e.exports='---\ntitle: Amazon Athena\n---\n\n# Amazon Athena\n\nTo add a database connection, click on the **gear** icon in the top right, and navigate to **Admin settings** > **Databases** > **Add a database**.\n\n## Connection and sync\n\nAfter connecting to a database, you\'ll see the "Connection and sync" section that displays the current connection status and options to manage your database connection.\n\nHere you can [sync the database schema and rescan field values](../sync-scan.md), and edit connection details.\n\n### Edit connection details\n\nYou can edit these settings at any time (and remember to save your changes).\n\n### Connection string\n\nPaste a connection string here to pre-fill the remaining fields below.\n\n### Display name\n\nThe display name for the database in the Metabase interface.\n\n### Region\n\nThe AWS region where your database is hosted, for Amazon Athena. For example, you might enter `us-east-1`.\n\n### Workgroup\n\nAWS workgroup. For example: `primary`. See [documentation on workgroups](https://docs.aws.amazon.com/athena/latest/ug/user-created-workgroups.html).\n\n### S3 Staging directory\n\nThis S3 staging directory must be in the same region you specify above.\n\n### Access key\n\nPart of IAM credentials for AWS. Metabase will encrypt these credentials.\n\nIf you\'re running Metabase on AWS and want to use [AWS Default Credentials Chain](https://docs.aws.amazon.com/sdk-for-java/v1/developer-guide/credentials.html#credentials-default), leave the Access and Secret keys blank.\n\nSee also our [notes on connecting to Athena](#notes-on-connecting-to-athena).\n\n### Secret Key\n\nPart of IAM credentials for AWS. Metabase will encrypt these credentials.\n\n### Additional Athena connection string options\n\nYou can specify additional options via a string, e.g., `UseResultsetStreaming=0;LogLevel=6`.\n\n### Include User ID and query hash in queries\n\nThis can be useful for auditing and debugging, but prevents databases from caching results and may increase your costs. Enable this feature if you need to track which users are running specific queries.\n\n### Re-run queries for simple explorations\n\nTurn this option **OFF** if people want to click **Run** (the play button) before applying any [Summarize](../../questions/query-builder/summarizing-and-grouping.md) or filter selections.\n\nBy default, Metabase will execute a query as soon as you choose an grouping option from the **Summarize** menu or a filter condition from the [drill-through menu](https://www.metabase.com/learn/metabase-basics/querying-and-dashboards/questions/drill-through). If your database is slow, you may want to disable re-running to avoid loading data on each click.\n\n### Choose when syncs and scans happen\n\nSee [syncs and scans](../sync-scan.md#choose-when-syncs-and-scans-happen).\n\n### Periodically refingerprint tables\n\n> Periodic refingerprinting will increase the load on your database.\n\nTurn this option **ON** to scan a sample of values every time Metabase runs a [sync](../sync-scan.md#how-database-syncs-work).\n\nA fingerprinting query examines the first 10,000 rows from each column and uses that data to guesstimate how many unique values each column has, what the minimum and maximum values are for numeric and timestamp columns, and so on. If you leave this option **OFF**, Metabase will only fingerprint your columns once during setup.\n\n## Notes on connecting to Athena\n\nIf you use other AWS services, we recommend that you create a special AWS Service Account that only has the permissions required to run Athena, and input the IAM credentials from that account to connect Metabase to Athena.\n\nSee [Identity and access management in Athena](https://docs.aws.amazon.com/athena/latest/ug/security-iam-athena.html).\n\n### Connecting using AWS Default Credentials Chain\n\nIf you\'re running Metabase on AWS and want to use [AWS Default Credentials Chain](https://docs.aws.amazon.com/sdk-for-java/v1/developer-guide/credentials.html#credentials-default), leave the Access and Secret keys blank.\n\n- For EC2, you can use [instance profiles](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2_instance-profiles.html).\n- For ECS, you can use [IAM roles for tasks](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html)\n\nIn both cases, the Athena driver will automatically fetch session credentials based on which IAM role you\'ve configured.\n\n### Permissions and IAM Policies\n\nMost issues that we see when people attempt to connect to AWS Athena involve permissions. Querying AWS Athena requires permissions to:\n\n- AWS Athena.\n- AWS Glue.\n- The S3 bucket where Athena results are stored.\n- The resources that Athena is querying against (i.e., the S3 bucket(s) Athena is querying).\n- If you\'re using AWS Lake Formation, then you also need to grant AWS Lake Formation permissions through the AWS Console (AWS Lake Formation > Permissions > Data Lake Permissions > Grant data lake permissions; the role Metabase uses needs SELECT and DESCRIBE table permissions).\n\n### Example IAM Policy\n\nThis policy provides read-only permissions for data in S3. You\'ll need to specify any S3 buckets that you want Metabase to be able to query from _as well as_ the S3 bucket provided as part of the configuration where results are written to.\n\nThere may be additional permissions required for other Athena functionality, like federated queries. For details, check out the [Athena docs](https://docs.aws.amazon.com/athena/latest/ug/security-iam-athena).\n\n```json\n{\n  "Version": "2012-10-17",\n  "Statement": [\n    {\n      "Sid": "Athena",\n      "Effect": "Allow",\n      "Action": [\n        "athena:BatchGetNamedQuery",\n        "athena:BatchGetQueryExecution",\n        "athena:GetNamedQuery",\n        "athena:GetQueryExecution",\n        "athena:GetQueryResults",\n        "athena:GetQueryResultsStream",\n        "athena:GetWorkGroup",\n        "athena:ListDatabases",\n        "athena:ListDataCatalogs",\n        "athena:ListNamedQueries",\n        "athena:ListQueryExecutions",\n        "athena:ListTagsForResource",\n        "athena:ListWorkGroups",\n        "athena:ListTableMetadata",\n        "athena:StartQueryExecution",\n        "athena:StopQueryExecution",\n        "athena:CreatePreparedStatement",\n        "athena:DeletePreparedStatement",\n        "athena:GetPreparedStatement",\n        "athena:GetTableMetadata"\n      ],\n      "Resource": "*"\n    },\n    {\n      "Sid": "Glue",\n      "Effect": "Allow",\n      "Action": [\n        "glue:BatchGetPartition",\n        "glue:GetDatabase",\n        "glue:GetDatabases",\n        "glue:GetPartition",\n        "glue:GetPartitions",\n        "glue:GetTable",\n        "glue:GetTables",\n        "glue:GetTableVersion",\n        "glue:GetTableVersions"\n      ],\n      "Resource": "*"\n    },\n    {\n      "Sid": "S3ReadAccess",\n      "Effect": "Allow",\n      "Action": ["s3:GetObject", "s3:ListBucket", "s3:GetBucketLocation"],\n      "Resource": [\n        "arn:aws:s3:::bucket1",\n        "arn:aws:s3:::bucket1/*",\n        "arn:aws:s3:::bucket2",\n        "arn:aws:s3:::bucket2/*"\n      ]\n    },\n    {\n      "Sid": "AthenaResultsBucket",\n      "Effect": "Allow",\n      "Action": [\n        "s3:PutObject",\n        "s3:GetObject",\n        "s3:AbortMultipartUpload",\n        "s3:ListBucket",\n        "s3:GetBucketLocation"\n      ],\n      "Resource": ["arn:aws:s3:::bucket2", "arn:aws:s3:::bucket2/*"]\n    }\n  ]\n}\n```\n\nIf Metabase also needs to create tables, you\'ll need additional AWS Glue permissions. The `"Resource": "*"` key-value pair gives the account Delete and Update permissions to any table:\n\n```json\n{\n  "Version": "2012-10-17",\n  "Statement": [\n    {\n      "Sid": "VisualEditor0",\n      "Effect": "Allow",\n      "Action": [\n        "glue:BatchCreatePartition",\n        "glue:UpdateDatabase",\n        "glue:DeleteDatabase",\n        "glue:CreateTable",\n        "glue:CreateDatabase",\n        "glue:UpdateTable",\n        "glue:BatchDeletePartition",\n        "glue:BatchDeleteTable",\n        "glue:DeleteTable",\n        "glue:CreatePartition",\n        "glue:DeletePartition",\n        "glue:UpdatePartition",\n        "glue:GetCatalogImportStatus"\n      ],\n      "Resource": "*"\n    }\n  ]\n}\n```\n\n## Model features\n\nThere aren\'t (yet) any model features available for Athena.\n\n## Database routing\n\nWith database routing, an admin can build a question once using a single data connection, and the question will run its query against a different data connection with the same schema depending on who is viewing the question.\n\nAdmittedly, the name "database routing" is misleading for Athena, because the term "database" in Athena is closer to "schema" in other databases. You _can\'t_ use database routing to route queries between different _databases_ in Athena, but you _can_ route between different data _connections_, e.g., different regions or buckets, or different IAM users, or different data sources/catalogs.\n\nSee [Database routing](../../permissions/database-routing.md).\n\n## Danger zone\n\nSee [Danger Zone](../danger-zone.md).\n\n## Further reading\n\n- [Managing databases](../../databases/connecting.md)\n- [Metadata editing](../../data-modeling/metadata-editing.md)\n- [Models](../../data-modeling/models.md)\n- [Setting data access permissions](../../permissions/data.md)\n'}}]);