/*
 * This file is subject to the terms and conditions defined in
 * file 'LICENSE.txt', which is part of this source code package.
 */

"use strict";(self.webpackChunk=self.webpackChunk||[]).push([["825"],{35048:function(e){e.exports="---\ntitle: MySQL\nredirect_from:\n  - /docs/latest/administration-guide/databases/mysql\n---\n\n# MySQL\n\n> This page covers connecting to MySQL as a _data warehouse_. For using MySQL as Metabase's _application database_, see [Configuring the Metabase application database](../../installation-and-operation/configuring-application-database.md).\n\nTo add a database connection, click on the **gear** icon in the top right, and navigate to **Admin settings** > **Databases** > **Add a database**.\n\n## Supported versions\n\nMetabase supports the oldest supported version through the latest stable version. See [MySQL end-of-life dates](https://endoflife.software/applications/databases/mysql).\n\n## Edit connection details\n\nYou can edit these settings at any time. Just remember to save your changes.\n\n### Connection string\n\nPaste a connection string here to pre-fill the remaining fields below.\n\n### Display name\n\nThe display name for the database in the Metabase interface.\n\n### Host\n\nYour database's IP address, or its domain name (e.g., esc.mydatabase.com).\n\n### Port\n\nThe database port. E.g., 3306.\n\n### Username\n\nThe database username for the account that you want to use to connect to your database. You can set up multiple connections to the same database using different user accounts to connect to the same database, each with different sets of [privileges](../users-roles-privileges.md).\n\n### Password\n\nThe password for the username that you use to connect to the database.\n\n### Use a secure connection (SSL)\n\nYou can paste your server's SSL certification chain.\n\n### Use an SSH tunnel\n\nSee our [guide to SSH tunneling](../ssh-tunnel.md).\n\n### Unfold JSON Columns\n\nFor MySQL databases, Metabase can unfold JSON columns into component fields to yield a table where each JSON key becomes a column. JSON unfolding is on by default, but you can turn off JSON unfolding if performance is slow.\n\nIf you turn on JSON unfolding, you can also toggle the unfolding for individual columns in [table metadata](../../data-modeling/metadata-editing.md#unfold-json).\n\n### Additional JDBC connection string options\n\nYou can append options to the connection string that Metabase uses to connect to your database.\n\n### Re-run queries for simple explorations\n\nTurn this option **OFF** if people want to click **Run** (the play button) before applying any [Summarize](../../questions/query-builder/summarizing-and-grouping.md) or filter selections.\n\nBy default, Metabase will execute a query as soon as you choose an grouping option from the **Summarize** menu or a filter condition from the [drill-through menu](https://www.metabase.com/learn/metabase-basics/querying-and-dashboards/questions/drill-through). If your database is slow, you may want to disable re-running to avoid loading data on each click.\n\n### Choose when syncs and scans happen\n\nSee [syncs and scans](../sync-scan.md#choose-when-syncs-and-scans-happen).\n\n### Periodically refingerprint tables\n\n> Periodic refingerprinting will increase the load on your database.\n\nTurn this option **ON** to scan a sample of values every time Metabase runs a [sync](../sync-scan.md#how-database-syncs-work).\n\nA fingerprinting query examines the first 10,000 rows from each column and uses that data to guesstimate how many unique values each column has, what the minimum and maximum values are for numeric and timestamp columns, and so on. If you leave this option **OFF**, Metabase will only fingerprint your columns once during setup.\n\n## Connecting to MySQL 8+ servers\n\nMetabase uses the MariaDB connector to connect to MySQL servers. The MariaDB connector lacks support for MySQL 8's default authentication plugin. In order to connect, you'll need to change the plugin used by the Metabase user:\n\n```\nmysql_native_password`: `ALTER USER 'metabase'@'%' IDENTIFIED WITH mysql_native_password BY 'thepassword';\n```\n\n### Unable to log in with correct credentials\n\n**How to detect this:** Metabase fails to connect to your MySQL server with the error message \"Looks like the username or password is incorrect\", but you're sure that the username and password is correct. You may have created the MySQL user with an allowed host other than the host you're connecting from.\n\nFor example, if the MySQL server is running in a Docker container, and your `metabase` user was created with `CREATE USER 'metabase'@'localhost' IDENTIFIED BY 'thepassword';`, the `localhost` will be resolved to the Docker container, and not the host machine, causing access to be denied.\n\nYou can identify this issue by looking in the Metabase server logs for the error message:\n\n```\nAccess denied for user 'metabase'@'172.17.0.1' (using password: YES).\n```\n\nNote the host name `172.17.0.1` (in this case a Docker network IP address), and `using password: YES` at the end.\n\nYou'll see the same error message when attempting to connect to the MySQL server with the command-line client: `mysql -h 127.0.0.1 -u metabase -p`.\n\n**How to fix this:** Recreate the MySQL user with the correct host name:\n\n```sql\nCREATE USER 'metabase'@'172.17.0.1' IDENTIFIED BY 'thepassword';\n```\n\nOtherwise, if necessary, a wildcard may be used for the host name:\n\n```sql\nCREATE USER 'metabase'@'%' IDENTIFIED BY 'thepassword';\n```\n\nThat user's permissions will need to be set:\n\n```sql\nGRANT SELECT ON targetdb.* TO 'metabase'@'172.17.0.1';\nFLUSH PRIVILEGES;\n```\n\nRemember to drop the old user:\n\n```sql\nDROP USER 'metabase'@'localhost';\n```\n\nIf you can't connect to the database, but the user, host, and password are correct, try adding `trustServerCertificate=true` to the additional JDBC options. This option will tell the Metabase driver to trust the server certificate even though it lacks a root certificate, and it should establish a secure connection.\n\n## Syncing records that include JSON\n\n**Metabase will infer the JSON \"schema\" based on the keys in the first five hundred rows of a table.** MySQL JSON fields lack schema, so Metabase can't rely on table metadata to define which keys a JSON field has. To work around the lack of schema, Metabase will get the first five hundred records and parse the JSON in those records to infer the JSON's \"schema\". The reason Metabase limits itself to five hundred records is so that syncing metadata doesn't put unnecessary strain on your database.\n\nThe problem is that, if the keys in the JSON vary record to record, the first five hundred rows may not capture all the keys used by JSON objects in that JSON field. To get Metabase to infer all the JSON keys, you'll need to add the additional keys to the JSON objects in the first five hundred rows.\n\n## Raising a MySQL Docker container of MySQL 8+\n\nIf you are spinning up a new MySQL container, and:\n\n- you want Metabase to connect to the container without having to manually create the user or change the authentication mechanism,\n- or you're facing a `RSA public key is not available client side (option serverRsaPublicKeyFile not set)` error,\n\nUse the `['--default-authentication-plugin=mysql_native_password']` modifiers when you run the container, like so:\n\n- a simple docker run: `docker run -p 3306:3306 -e MYSQL_ROOT_PASSWORD=xxxxxx mysql:8.xx.xx --default-authentication-plugin=mysql_native_password`\n\n- or in docker-compose:\n\n```yml\nmysql:\n  image: mysql:8.xx.xx\n  container_name: mysql\n  hostname: mysql\n  ports:\n    - 3306:3306\n  environment:\n    - \"MYSQL_ROOT_PASSWORD=xxxxxx\"\n    - \"MYSQL_USER=metabase\"\n    - \"MYSQL_PASSWORD=xxxxxx\"\n    - \"MYSQL_DATABASE=metabase\"\n  volumes:\n    - $PWD/mysql:/var/lib/mysql\n  command: [\"--default-authentication-plugin=mysql_native_password\"]\n```\n\n## Limitations with Vitess-based databases\n\n- When querying Vitess databases (like Planetscale), you should add a `LIMIT` clause inside each subquery.\n\n  The reason: typically, Metabase applies limits (e.g., 2000 or 10000 rows) to the final query results. But due to a known bug in Vitess, Vitess might apply these limits to subqueries, which can lead to unexpected results (for example, not all rows of results will be displayed within Metabase). The workaround is to add limits to each of your subqueries.\n\n- You may want to check in with the vendor that's hosting the platform, as Vitess can run into issues returning metadata from the information schema. Metabase needs this metadata to populate its application database; if Metabase can't get that metadata, fields may not appear (or appear empty).\n\n## Passwords with special characters\n\nIf your password contains characters that aren't UTF-8, then you might need to add an additional variable to the connection string `passwordCharacterEncoding=<your_encoding_here>`. This ensures that MySQL understands the special characters in the password during authentication.\n\n## Model features\n\nChoose whether to enable features related to [Metabase models](../../data-modeling/models.md). These features will often require that the database user account, the one you use to connect to your database, has both read and write privileges.\n\n### Model actions\n\nTurn this setting on to allow [actions](../../actions/introduction.md) from models created from this data to be run. Actions are able to read, write, and possibly delete data. Your database user will need write permissions.\n\n### Model persistence\n\nWe'll create tables with model data and refresh them on a schedule you define. To enable [model persistence](../../data-modeling/model-persistence.md), you need to grant this connection's credentials read and write permissions on a schema Metabase provides.\n\n## Editable table data\n\nTurn this setting **ON** to enable editing of table data directly within Metabase. When enabled, Admins can create, update, and delete records in your tables through Metabase's interface.\n\nYour database connection will need Write permissions to enable this feature. Meaning: the database user account that you use to connect Metabase to your database must have appropriate privileges to modify data in the tables you want to make editable.\n\nSee [privileges](../users-roles-privileges.md).\n\n## Database routing\n\nWith database routing, an admin can build a question once using one database, and the question will run its query against a different database with the same schema depending on who is viewing the question.\n\nSee [Database routing](../../permissions/database-routing.md).\n\n## Danger zone\n\nSee [Danger zone](../danger-zone.md).\n\n## Further reading\n\n- [MariaDB](./mariadb.md)\n- [Managing databases](../../databases/connecting.md)\n- [Metadata editing](../../data-modeling/metadata-editing.md)\n- [Models](../../data-modeling/models.md)\n- [Setting data access permissions](../../permissions/data.md)\n"}}]);