/*
 * This file is subject to the terms and conditions defined in
 * file 'LICENSE.txt', which is part of this source code package.
 */

"use strict";(self.webpackChunk=self.webpackChunk||[]).push([["952"],{72371:function(e){e.exports="---\ntitle: SparkSQL\n---\n\n# SparkSQL\n\nTo add a database connection, click on the **gear** icon in the top right, and navigate to **Admin settings** > **Databases** > **Add a database**.\n\n## Settings\n\nYou can edit these settings at any time. Just remember to save your changes.\n\n### Connection string\n\nPaste a connection string here to pre-fill the remaining fields below.\n\n### Display name\n\nThe display name for the database in the Metabase interface.\n\n### Host\n\nYour database's IP address, or its domain name (e.g., esc.mydatabase.com).\n\n### Port\n\nThe database port. E.g., 10000\n\n### Username\n\nThe database username for the account that you want to use to connect to your database. You can set up multiple connections to the same database using different user accounts to connect to the same database, each with different sets of [privileges](../users-roles-privileges.md).\n\n### Password\n\nThe password for the username that you use to connect to the database.\n\n### Use an SSH tunnel\n\nSee our [guide to SSH tunneling](../ssh-tunnel.md).\n\n### Additional JDBC connection string options\n\nYou can append options to the connection string that Metabase uses to connect to your database.\n\n### Re-run queries for simple explorations\n\nTurn this option **OFF** if people want to click **Run** (the play button) before applying any [Summarize](../../questions/query-builder/summarizing-and-grouping.md) or filter selections.\n\nBy default, Metabase will execute a query as soon as you choose an grouping option from the **Summarize** menu or a filter condition from the [drill-through menu](https://www.metabase.com/learn/metabase-basics/querying-and-dashboards/questions/drill-through). If your database is slow, you may want to disable re-running to avoid loading data on each click.\n\n### Choose when Metabase syncs and scans\n\nTurn this option **ON** to manage the queries that Metabase uses to stay up to date with your database. For more information, see [Syncing and scanning databases](../sync-scan.md).\n\n#### Database syncing\n\nIf you've selected **Choose when syncs and scans happen** > **ON**, you'll be able to set:\n\n- The frequency of the [sync](../sync-scan.md#how-database-syncs-work): hourly (default) or daily.\n- The time to run the sync, in the timezone of the server where your Metabase app is running.\n\n#### Scanning for filter values\n\nMetabase can scan the values present in each field in this database to enable checkbox filters in dashboards and questions. This can be a somewhat resource-intensive process, particularly if you have a very large database.\n\nIf you've selected **Choose when syncs and scans happen** > **ON**, you'll see the following options under **Scanning for filter values**:\n\n- **Regularly, on a schedule** allows you to run [scan queries](../sync-scan.md#how-database-scans-work) at a frequency that matches the rate of change to your database. The time is set in the timezone of the server where your Metabase app is running. This is the best option for a small database, or tables with distinct values that get updated often.\n- **Only when adding a new filter widget** is a great option if you want scan queries to run on demand. Turning this option **ON** means that Metabase will only scan and cache the values of the field(s) that are used when a new filter is added to a dashboard or SQL question.\n- **Never, I'll do this manually if I need to** is an option for databases that are either prohibitively large, or which never really have new values added. Use the [Re-scan field values now](../sync-scan.md#manually-scanning-column-values) button to run a manual scan and bring your filter values up to date.\n\n### Periodically refingerprint tables\n\n> Periodic refingerprinting will increase the load on your database.\n\nTurn this option **ON** to scan a sample of values every time Metabase runs a [sync](../sync-scan.md#how-database-syncs-work).\n\nA fingerprinting query examines the first 10,000 rows from each column and uses that data to guesstimate how many unique values each column has, what the minimum and maximum values are for numeric and timestamp columns, and so on. If you leave this option **OFF**, Metabase will only fingerprint your columns once during setup.\n\n## Danger zone\n\nSee [Danger zone](../danger-zone.md).\n\n## Further reading\n\n- [Managing databases](../../databases/connecting.md)\n- [Metadata editing](../../data-modeling/metadata-editing.md)\n- [Models](../../data-modeling/models.md)\n- [Setting data access permissions](../../permissions/data.md)\n"}}]);