/*
 * This file is subject to the terms and conditions defined in
 * file 'LICENSE.txt', which is part of this source code package.
 */

"use strict";(self.webpackChunk=self.webpackChunk||[]).push([["641"],{64880:function(n){n.exports="---\ntitle: Starburst\ndescription: Learn how to connect Metabase to your Starburst or Trino database, including connection settings, SSL configuration, and database sync options.\n---\n\n# Starburst\n\n> This driver also works for connections to a Trino database.\n\nTo add a database connection, click on the **gear** icon in the top right, and navigate to **Admin settings** > **Databases** > **Add a database**.\n\nYou can edit these settings at any time. Just remember to save your changes.\n\n## Connection and Sync\n\nAfter connecting to a database, you'll see the \"Connection and sync\" section that displays the current connection status and options to manage your database connection.\n\nHere you can [sync the database schema and rescan field values](../sync-scan.md), and edit connection details.\n\n## Edit connection details\n\nTo access or modify your database connection settings, click the **Edit connection details** button.\n\n### Connection string\n\nPaste a connection string here to pre-fill the remaining fields below.\n\n### Display name\n\nThe display name for the database in the Metabase interface.\n\n### Host\n\nYour database's IP address (e.g., `98.137.149.56`) or its domain name (e.g., `name.database.com`).\n\n### Port\n\nThe database port (e.g., `8080`).\n\n### Catalog\n\nStarburt catalogs contain schemas and reference data sources via a connector.\n\n### Schema (optional)\n\nOnly add tables that come from a specific schema.\n\n### Username\n\nThe database username for the account that you want to use to connect to your database. You can set up multiple connections to the same database using different user accounts to connect to the same database, each with different sets of [privileges](../users-roles-privileges.md).\n\n### Password\n\nThe password for the username that you use to connect to the database.\n\n### Use a secure connection (SSL)\n\nSee [SSL certificates](../ssl-certificates.md).\n\n### Role (optional)\n\nSpecify a role to override the database user's default role.\n\n### Optimize prepared statements\n\nRequires Starburst Galaxy, Starburst Enterprise (version 420-e or higher), or Trino (version 418 or higher).\n\n### Additional JDBC connection string options\n\nYou can append options to the JDBC connection string. Separate options with `&`, like so:\n\n```\nconnection_timeout=1000&socket_timeout=300000\n```\n\n### Re-run queries for simple explorations\n\nTurn this option **OFF** if people want to click **Run** (the play button) before applying any [Summarize](../../questions/query-builder/summarizing-and-grouping.md) or filter selections.\n\nBy default, Metabase will execute a query as soon as you choose an grouping option from the **Summarize** menu or a filter condition from the [drill-through menu](https://www.metabase.com/learn/metabase-basics/querying-and-dashboards/questions/drill-through). If your database is slow, you may want to disable re-running to avoid loading data on each click.\n\n### Choose when syncs and scans happen\n\nSee [syncs and scans](../sync-scan.md#choose-when-syncs-and-scans-happen).\n\n### Periodically refingerprint tables\n\n> Periodic refingerprinting will increase the load on your database.\n\nTurn this option **ON** to scan a sample of values every time Metabase runs a [sync](../sync-scan.md#how-database-syncs-work).\n\nA fingerprinting query examines the first 10,000 rows from each column and uses that data to guesstimate how many unique values each column has, what the minimum and maximum values are for numeric and timestamp columns, and so on. If you leave this option **OFF**, Metabase will only fingerprint your columns once during setup.\n\n## Model features\n\nThere aren't (yet) any model features for Starburst.\n\n## Database routing\n\nWith database routing, an admin can build a question once using one database (data catalog), and the question will run its query against a different data catalog with the same schema depending on who is viewing the question.\n\nSee [Database routing](../../permissions/database-routing.md).\n\n## Danger zone\n\nSee [Danger zone](../danger-zone.md).\n"}}]);