/*
 * This file is subject to the terms and conditions defined in
 * file 'LICENSE.txt', which is part of this source code package.
 */

"use strict";(self.webpackChunk=self.webpackChunk||[]).push([["58"],{86657:function(n){n.exports="---\ntitle: Amazon Redshift\ndescription: Connect Metabase to Amazon Redshift data warehouses to run queries and create dashboards.\nredirect_from:\n  - /docs/latest/administration-guide/databases/redshift\n---\n\n# Amazon Redshift\n\nTo add a database connection, click on the **gear** icon in the top right, and navigate to **Admin settings** > **Databases** > **Add a database**.\n\n## Connection and sync\n\nAfter connecting to a database, you'll see the \"Connection and sync\" section that displays the current connection status and options to manage your database connection.\n\nHere you can [sync the database schema and rescan field values](../sync-scan.md), and edit connection details.\n\n## Edit connection details\n\nTo access or modify your database connection settings, click the **Edit connection details** button.\n\n### Connection string\n\nPaste a connection string here to pre-fill the remaining fields below.\n\n### Display name\n\nThe display name for the database in the Metabase interface.\n\n### Host\n\nYour database's IP address, or its domain name (e.g., esc.mydatabase.com).\n\n### Port\n\nThe database port. E.g., 3306.\n\n### Database name\n\nThe name of the database you want to connect to.\n\n### Schemas\n\nHere you can specify which schemas you want to sync and scan. Options are:\n\n- All\n- Only these...\n- All except...\n\nFor the **Only these** and **All except** options, you can input a comma-separated list of values to tell Metabase which schemas you want to include (or exclude). For example:\n\n```\nfoo,bar,baz\n```\n\nYou can use the `*` wildcard to match multiple schemas.\n\nLet's say you have three schemas: foo, bar, and baz.\n\n- If you have **Only these...** set, and enter the string `b*`, you'll sync with bar and baz.\n- If you have **All except...** set, and enter the string `b*`, you'll just sync foo.\n\nNote that only the `*` wildcard is supported; you can't use other special characters or regexes.\n\n### Username\n\n> In order for sync and scan to work, make sure this database user account has access to the `information_schema`.\n\nThe database username for the account that you want to use to connect to your database. You can set up multiple connections to the same database using different user accounts to connect to the same database, each with different sets of [privileges](../users-roles-privileges.md).\n\n### Password\n\nThe password for the username that you use to connect to the database.\n\n### Use an SSH tunnel\n\nSee our [guide to SSH tunneling](../ssh-tunnel.md).\n\n### Additional JDBC connection string options\n\nYou can append options to the connection string that Metabase uses to connect to your database.\n\n### Re-run queries for simple explorations\n\nTurn this option **OFF** if people want to click **Run** (the play button) before applying any [Summarize](../../questions/query-builder/summarizing-and-grouping.md) or filter selections.\n\nBy default, Metabase will execute a query as soon as you choose an grouping option from the **Summarize** menu or a filter condition from the [drill-through menu](https://www.metabase.com/learn/metabase-basics/querying-and-dashboards/questions/drill-through). If your database is slow, you may want to disable re-running to avoid loading data on each click.\n\n### Choose when syncs and scans happen\n\nSee [syncs and scans](../sync-scan.md#choose-when-syncs-and-scans-happen).\n\n### Periodically refingerprint tables\n\n> Periodic refingerprinting will increase the load on your database.\n\nTurn this option **ON** to scan a sample of values every time Metabase runs a [sync](../sync-scan.md#how-database-syncs-work).\n\nA fingerprinting query examines the first 10,000 rows from each column and uses that data to guesstimate how many unique values each column has, what the minimum and maximum values are for numeric and timestamp columns, and so on. If you leave this option **OFF**, Metabase will only fingerprint your columns once during setup.\n\n## Model features\n\nChoose whether to enable features related to Metabase models. These will often require a write connection.\n\n### Model persistence\n\nYou can enable model persistence to allow Metabase to create tables with model data and refresh them on a schedule. This requires write permissions to a designated schema.\n\nCheck out [Model persistence](../../data-modeling/model-persistence.md).\n\n## Database routing\n\nWith database routing, an admin can build a question once using one database, and the question will run its query against a different database with the same schema depending on who is viewing the question.\n\nSee [Database routing](../../permissions/database-routing.md).\n\n## Danger zone\n\nSee [Danger zone](../danger-zone.md).\n\n## Further reading\n\n- [Managing databases](../../databases/connecting.md)\n- [Metadata editing](../../data-modeling/metadata-editing.md)\n- [Models](../../data-modeling/models.md)\n- [Setting data access permissions](../../permissions/data.md)\n"}}]);