/*
 * This file is subject to the terms and conditions defined in
 * file 'LICENSE.txt', which is part of this source code package.
 */

"use strict";(self.webpackChunk=self.webpackChunk||[]).push([["86"],{40797:function(e){e.exports="---\ntitle: \"Connecting to AWS's Relational Database Service (RDS)\"\nredirect_from:\n  - /docs/latest/administration-guide/databases/aws-rds\n---\n\n# Connecting to AWS's Relational Database Service (RDS)\n\nRDS offers several databases that Metabase officially supports, including PostgreSQL, MySQL, MariaDB, Oracle, and SQL server.\n\nHere's how to get connection information for databases on Amazon's RDS:\n\n1. Go to your AWS Management Console.\n   - Need help finding that? Visit `https://**My_AWS_Account_ID**.signin.aws.amazon.com/console`. Be sure to insert your own AWS Account ID, though!\n2. Go to **Database** > **RDS** > **Instances**.\n3. Select the database you want to connect to Metabase.\n4. Get the information you'll need to connect Metabase to your RDS:\n   - **Hostname**. This is listed as the Endpoint parameter.\n   - **Port**. Find the port parameter under Security and Network.\n   - **Username**. Find this under Configuration Details.\n   - **Database Name**. Find this under Configuration Details.\n   - **Password**. Ask your database administrator for the password.\n\n## IAM authentication\n\n{% include plans-blockquote.html feature=\"IAM authentication\" self-hosted-only=\"true\" %}\n\nYou can connect to RDS PostgreSQL and MySQL instances and Aurora PostgreSQL/MySQL using AWS IAM authentication instead of a password.\n\nTo set up IAM authentication:\n\n1. [In AWS, enable IAM authentication on your RDS instance](#in-aws-enable-iam-authentication-on-your-rds-instance)\n2. [In AWS, set up an IAM policy](#in-aws-set-up-an-iam-policy)\n3. [In your database, create a database user](#in-your-database-create-a-database-user)\n4. [In your Metabase environment, configure AWS credentials](#in-your-metabase-environment-configure-aws-credentials)\n5. [In Metabase, select IAM authentication](#in-metabase-select-iam-authentication)\n6. [In Metabase, configure SSL](#in-metabase-configure-ssl)\n\n### In AWS, enable IAM authentication on your RDS instance\n\n[Enable IAM authentication on your RDS instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.Enabling.html) in the AWS console.\n\n### In AWS, set up an IAM policy\n\nAdd a policy with the `rds-db:connect` action. The policy resource must specify the [Amazon Resource Name (ARN)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html) of your database user in the format:\n\n```\narn:aws:rds-db:region:account-id:dbuser:DbiResourceId/db-user-name\n```\n\nWhen entering the username in Metabase, you'd just enter your `db-user-name`, not the full ARN.\n\nSee [Creating IAM policy for IAM database access](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.IAMPolicy.html).\n\n### In your database, create a database user\n\nCreate the database user with IAM authentication enabled. The database username must match exactly (case-sensitive) with the `db-user-name` portion of your IAM policy [Amazon Resource Name (ARN)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html).\n\n**PostgreSQL:**\n\n```sql\nCREATE USER your_username;\nGRANT rds_iam TO your_username;\n```\n\n**MySQL:**\n\n```sql\nCREATE USER 'your_username'@'%' IDENTIFIED WITH AWSAuthenticationPlugin AS 'RDS';\n```\n\nSee [Setting up for IAM database authentication](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.DBAccounts.html).\n\n### In your Metabase environment, configure AWS credentials\n\nAuthentication credentials must be available via one of the methods supported by the [AWS SDK credentials chain](https://docs.aws.amazon.com/sdk-for-java/latest/developer-guide/credentials-chain.html), typically either:\n\n- Environment variables (`AWS_ACCESS_KEY_ID` and `AWS_SECRET_ACCESS_KEY`)\n- AWS credentials file (`.aws/credentials`), automatically available if running in [Elastic Container Service (ECS)](https://docs.aws.amazon.com/ecs/)\n\n### In Metabase, select IAM authentication\n\nWhen adding or editing a database connection in Metabase, click **Use an authentication provider** and select **IAM Authentication**.\n\n### In Metabase, configure SSL\n\nUse a secure connection (SSL):\n\n- **PostgreSQL**: Set the SSL Mode to **require**. See [PostgreSQL SSL options](./postgresql.md#ssl-mode).\n- **MySQL**: The SSL Mode will be automatically set to **verify-ca**. If you manually change the SSL Mode, it must be set to **verify-ca**. See [MySQL SSL options](./mysql.md#use-a-secure-connection-ssl).\n"}}]);